/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.hscmgt;

import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.websm.launch.hscmgt.HSCTarFile;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class RestoreHSCSystemUpgradeData {
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private static final String HSC_EXCLUDE_FILE_LIST = "/opt/hsc/data/hsc_exclude.list";
    private static final String MCP_EXCLUDE_FILE_LIST = "/opt/hsc/data/mcp_exclude.list";
    private static final String LOG_FILE = "/var/hsc/log/sysUpgrade.log";
    private static final String WORKING_DIR = "/tmp/restore/work/";
    private static final String IFCFG_LO = "/etc/sysconfig/network-scripts/ifcfg-lo";
    private static final String RESOLV_CONF = "/etc/resolv.conf";
    private static final String MODULES_CONF = "/etc/modules.conf";
    private static final String NETWORK = "/etc/sysconfig/network";
    private static final String STATIC_ROUTES = "/etc/sysconfig/static-routes";
    private static final String ROUTED = "/etc/sysconfig/routed";
    private static final String IFCFG_FILE = "/etc/sysconfig/network-scripts/ifcfg-eth";
    private static final String I18N = "/etc/sysconfig/i18n";
    private static final String CLOCK = "/etc/sysconfig/clock";
    private static final String TELNET = "/etc/xinetd.d/telnet";
    private static final String XF86CONFIG = "/etc/X11/XF86Config-4";
    private static final String LOGIN_DEFS = "/etc/login.defs";
    private static final String GROUP = "/etc/group";
    private static final String GROUP1 = "/etc/group-";
    private static final String PASSWD = "/etc/passwd";
    private static final String PASSWD1 = "/etc/passwd-";
    private static final String SHADOW = "/etc/shadow";
    private static final String SHADOW1 = "/etc/shadow-";
    private static final String REDHAT_CRON_ROOT_FILE = "/var/spool/cron/root";
    private static final String MCP_CRON_ROOT_FILE = "/var/spool/cron/tabs/root";
    private static final String HTTPD_USERS = "/usr/local/etc/httpd/users";
    private static final String KBD_CHECK = "/opt/hsc/data/keycfgcheck";
    private HSCTarFile hscTF = null;
    private String archive = null;
    public BufferedWriter restoreUpgradeLog = null;

    public void finalize() {
        this.logIt("==== End RestoreHSCSystemUpgradeData logging ====");
        try {
            this.restoreUpgradeLog.close();
            String string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("chown") + " root.root " + LOG_FILE;
            EExecResult eExecResult = EExec.Exec((String)string);
            string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("chmod") + " 400 " + LOG_FILE;
            eExecResult = EExec.Exec((String)string);
        }
        catch (Exception exception) {}
    }

    private void logIt(String string) {
        try {
            this.restoreUpgradeLog.write(string, 0, string.length());
            this.restoreUpgradeLog.newLine();
        }
        catch (Exception exception) {
            System.out.println("Error attempting to append to log file");
        }
    }

    public RestoreHSCSystemUpgradeData(String string) {
        this.archive = string;
        String string2 = null;
        try {
            FileWriter fileWriter = new FileWriter(LOG_FILE);
            this.restoreUpgradeLog = new BufferedWriter(fileWriter);
            this.logIt("==== Start RestoreHSCSystemUpgradeData logging ====");
            this.hscTF = new HSCTarFile(string);
            Vector vector = this.hscTF.listEntries();
            if (vector.contains(XF86CONFIG)) {
                this.logIt("In migration path...");
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("mkdir") + " -p " + WORKING_DIR;
                this.executeCommand(string2);
                this.logIt("About to migrate the network settings...");
                this.portNetwork();
                this.logIt("About to migrate misc system information...");
                this.portMisc();
                this.logIt("About to migrate locale information...");
                this.portLocale();
                this.logIt("About to migrate /etc/sysconfig/clock (timezone) information...");
                this.portClock();
                this.logIt("Changing system file ownership/permissions...");
                this.changeFilePermissions();
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -fr /tmp/restore";
                this.executeCommand(string2);
                this.hscTF.restoreArchiveX(MCP_EXCLUDE_FILE_LIST);
            } else {
                this.logIt("In non-migration MCP path...");
                this.hscTF.restoreArchiveX(HSC_EXCLUDE_FILE_LIST);
            }
            this.logIt("About to reset HMC hostname...");
            this.resetHostname();
        }
        catch (Exception exception) {
            this.logIt("Exception occurred in (main) RestoreHSCSystemUpgradeData method. e is " + exception);
        }
    }

    private void portNetwork() throws Exception {
        String string = null;
        this.logIt("--> Entering portNetwork()...");
        String string2 = null;
        string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + HSC_EXCLUDE_FILE_LIST + " " + MCP_EXCLUDE_FILE_LIST;
        this.executeCommand(string);
        this.hscTF.reset();
        while ((string2 = this.hscTF.getNextEntry()) != null) {
            if (string2.equals(MODULES_CONF)) {
                this.logIt("tar file match with /etc/modules.conf");
                string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + MODULES_CONF + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string);
                this.fixModConf(string2);
            }
            if (string2.equals(NETWORK)) {
                this.logIt("tar file match with /etc/sysconfig/network");
                string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + NETWORK + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string);
                this.fixNetwork(string2);
            }
            if (string2.equals(STATIC_ROUTES)) {
                this.logIt("tar file match with /etc/sysconfig/static-routes");
                string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + STATIC_ROUTES + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string);
                this.fixStaticRoutes(string2);
            }
            if (string2.indexOf(IFCFG_FILE) == -1) continue;
            this.logIt("tar file match with " + string2);
            string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + string2 + " >> " + MCP_EXCLUDE_FILE_LIST;
            this.executeCommand(string);
            this.fixCfgFile(string2);
        }
        string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " " + RESOLV_CONF;
        this.executeCommand(string);
        this.logIt("<-- Exit portNetwork()");
    }

    private void fixModConf(String string) {
        String string2 = null;
        Object var3_3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.logIt("--> Entering fixModConf()..., argument is <" + string + ">");
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + string;
        this.executeCommand(string2);
        try {
            String string9;
            this.logIt("About to read /tmp/restore/work/" + string + "...");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(WORKING_DIR + string));
            while ((string9 = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string9 + ">");
                if (string9.startsWith("alias")) {
                    if ((string9 = string9.substring(5).trim()).startsWith("eth0")) {
                        string3 = string9.substring(4).trim();
                        continue;
                    }
                    if (!string9.startsWith("eth1")) continue;
                    string4 = string9.substring(4).trim();
                    continue;
                }
                if (string9.startsWith("options")) {
                    if ((string9 = string9.substring(7).trim()).indexOf("e100") != -1) {
                        string5 = string9;
                        continue;
                    }
                    if (string9.indexOf("e1000") != -1) {
                        string6 = string9;
                        continue;
                    }
                    if (string9.indexOf("eepro100") == -1) continue;
                    string7 = string9;
                    continue;
                }
                if (!string9.startsWith("#tg3 ")) continue;
                string8 = string9;
            }
        }
        catch (Exception exception) {
            this.logIt("Exception occurred in fixModConf method. e is " + exception);
        }
        if (string3 != null) {
            this.logIt("eth0Driver is <" + string3 + ">");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("sed") + " -e \"/^alias eth0/d\" /etc/modules.conf > /etc/modules.conf.mod";
            this.executeCommand(string2);
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("mv") + " -f /etc/modules.conf.mod /etc/modules.conf";
            this.executeCommand(string2);
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " alias eth0 " + string3 + " >> /etc/modules.conf";
            this.executeCommand(string2);
        }
        if (string4 != null) {
            this.logIt("eth1Driver is <" + string4 + ">");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("sed") + " -e \"/^alias eth1/d\" /etc/modules.conf > /etc/modules.conf.mod";
            this.executeCommand(string2);
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("mv") + " -f /etc/modules.conf.mod /etc/modules.conf";
            this.executeCommand(string2);
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " alias eth1 " + string4 + " >> /etc/modules.conf";
            this.executeCommand(string2);
        }
        if (string5 != null) {
            this.logIt("e100Options is <" + string5 + ">");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " options " + string5 + " >> /etc/modules.conf";
            this.executeCommand(string2);
        }
        if (string6 != null) {
            this.logIt("e1000Options is <" + string6 + ">");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " options " + string6 + " >> /etc/modules.conf";
            this.executeCommand(string2);
        }
        if (string7 != null) {
            this.logIt("eepro100Options is <" + string6 + ">");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " options " + string7 + " >> /etc/modules.conf";
            this.executeCommand(string2);
        }
        if (string8 != null) {
            this.logIt("tg3Options is <" + string8 + ">");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + string8 + " >> /etc/modules.conf";
            this.executeCommand(string2);
        }
        this.logIt("<-- Exit fixModConf()");
    }

    private void fixNetwork(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = "-";
        this.logIt("--> Entering fixNetwork()..., argument is <" + string + ">");
        string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + string;
        this.executeCommand(string3);
        try {
            this.logIt("About to read /tmp/restore/work/" + string + "...");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(WORKING_DIR + string));
            while ((string2 = bufferedReader.readLine()) != null) {
                Properties properties;
                this.logIt("line read is <" + string2 + ">");
                if (string2.trim().startsWith("HOSTNAME")) {
                    properties = new Properties();
                    properties.load(new ByteArrayInputStream(string2.getBytes()));
                    string4 = RestoreHSCSystemUpgradeData.getAttrValue("HOSTNAME", properties);
                    if (string4.length() <= 1) continue;
                    string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + string4 + " > /etc/HOSTNAME";
                    this.executeCommand(string3);
                    continue;
                }
                if (string2.trim().startsWith("GATEWAYDEV")) {
                    this.logIt("found GATEWAYDEV match");
                    properties = new Properties();
                    properties.load(new ByteArrayInputStream(string2.getBytes()));
                    string5 = RestoreHSCSystemUpgradeData.getAttrValue("GATEWAYDEV", properties);
                    this.logIt("data is <" + string5 + ">");
                    if (string5.length() <= 1) continue;
                    string7 = string5;
                    continue;
                }
                if (!string2.trim().startsWith("GATEWAY")) continue;
                this.logIt("found GATEWAY match");
                properties = new Properties();
                properties.load(new ByteArrayInputStream(string2.getBytes()));
                string5 = RestoreHSCSystemUpgradeData.getAttrValue("GATEWAY", properties);
                this.logIt("data is <" + string5 + ">");
                if (string5.length() <= 1) continue;
                string6 = string5;
            }
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of /tmp/restore/work/" + string + ". e is " + exception);
        }
        if (string6 != null) {
            string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " default " + string6 + " - " + string7 + " > /etc/sysconfig/network/routes";
            this.executeCommand(string3);
        }
        this.logIt("<-- Exit fixNetwork()");
    }

    private void fixStaticRoutes(String string) {
        String string2 = null;
        Object var3_3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.logIt("--> Entering fixStaticRoutes()..., argument is <" + string + ">");
        string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + string;
        this.executeCommand(string3);
        try {
            this.logIt("About to read /tmp/restore/work/" + string + "...");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(WORKING_DIR + string));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string2 + ">");
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string6 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string7 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string8 = stringTokenizer.nextToken();
                    }
                    this.logIt("type/destination/netmask/gateway is :" + string5 + "/" + string6 + "/" + string7 + "/" + string8);
                    string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + string5 + " " + string6 + " " + string7 + " " + string8 + " >> /etc/sysconfig/network/routes";
                    this.executeCommand(string3);
                }
                catch (Exception exception) {
                    this.logIt("Exception caught during string tokenizing. e1 is " + exception);
                }
            }
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of /tmp/restore/work/" + string + ". e is " + exception);
        }
        this.logIt("<-- Exit fixStaticRoutes()");
    }

    private void fixCfgFile(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = new String("yes");
        this.logIt("--> Entering fixCfgFile()..., argument is <" + string + ">");
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + string;
        this.executeCommand(string2);
        int n = string.indexOf("ifcfg-eth");
        String string5 = string.substring(n);
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + WORKING_DIR + string + " /etc/sysconfig/network/" + string5;
        this.executeCommand(string2);
        try {
            this.logIt("About to read etc/sysconfig/network/" + string5 + "...");
            BufferedReader bufferedReader = new BufferedReader(new FileReader("etc/sysconfig/network/" + string5));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string3 + ">");
                if (!string3.trim().startsWith("ONBOOT")) continue;
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(string3.getBytes()));
                string4 = RestoreHSCSystemUpgradeData.getAttrValue("ONBOOT", properties);
                string4 = string4.toLowerCase();
            }
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of etc/sysconfig/network/" + string5 + ". e is " + exception);
        }
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("sed") + " -e \"/^ONBOOT/d\" /etc/sysconfig/network/" + string5 + " > /etc/sysconfig/network/" + string5 + ".mod";
        this.executeCommand(string2);
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("mv") + " -f /etc/sysconfig/network/" + string5 + ".mod /etc/sysconfig/network/" + string5;
        this.executeCommand(string2);
        if (string4.equals("yes")) {
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " STARTMODE=onboot >> /etc/sysconfig/network/" + string5;
            this.executeCommand(string2);
        } else {
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " STARTMODE=off >> /etc/sysconfig/network/" + string5;
            this.executeCommand(string2);
        }
        this.logIt("<-- Exit fixCfgFile()");
    }

    private void portMisc() {
        String string = null;
        String string2 = null;
        this.logIt("--> Entering portMisc()");
        this.hscTF.reset();
        while ((string = this.hscTF.getNextEntry()) != null) {
            if (string.startsWith("/etc/") && string.endsWith(".conf")) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + string + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(IFCFG_LO)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + IFCFG_LO + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(I18N)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + I18N + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(CLOCK)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + CLOCK + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(TELNET)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + TELNET + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(XF86CONFIG)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + XF86CONFIG + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(LOGIN_DEFS)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + LOGIN_DEFS + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(GROUP)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + GROUP + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(GROUP1)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + GROUP1 + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(PASSWD)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + PASSWD + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(PASSWD1)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + PASSWD1 + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(SHADOW)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + SHADOW + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(SHADOW1)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + SHADOW1 + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(REDHAT_CRON_ROOT_FILE)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + REDHAT_CRON_ROOT_FILE + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (string.equals(KBD_CHECK)) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + KBD_CHECK + " >> " + MCP_EXCLUDE_FILE_LIST;
                this.executeCommand(string2);
            }
            if (!string.startsWith("/home/") || !string.endsWith("WebSM.pref")) continue;
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " " + string + " >> " + MCP_EXCLUDE_FILE_LIST;
            this.executeCommand(string2);
        }
        this.logIt("About to invoke postProcessGroups()...");
        this.postProcessGroups();
        this.logIt("About to invoke postProcessShadow()...");
        this.postProcessShadow();
        this.logIt("cron 'root' file changed locations. migrating it...");
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + REDHAT_CRON_ROOT_FILE;
        this.executeCommand(string2);
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("mv") + " -f " + WORKING_DIR + REDHAT_CRON_ROOT_FILE + " " + MCP_CRON_ROOT_FILE;
        this.executeCommand(string2);
        this.logIt("<-- Exit portMisc()");
    }

    private void postProcessGroups() {
        String string = null;
        Vector vector = new Vector();
        this.logIt("--> Entering postProcessGroups()");
        string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + GROUP;
        this.executeCommand(string);
        string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + PASSWD;
        this.executeCommand(string);
        try {
            String string2;
            this.logIt("About to read /tmp/restore/work//etc/group...");
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/tmp/restore/work//etc/group"));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string2 + ">");
                String string3 = null;
                if (string2.startsWith("HSC_Sys_Prog") && (string3 = this.getOldGroupsUserList(string2)) != null) {
                    vector = this.getUniqueUserList(vector, string3);
                    this.addUserListToNewGroups("HSC_Sys_Prog", string3);
                }
                if (string2.startsWith("HSC_Admin") && (string3 = this.getOldGroupsUserList(string2)) != null) {
                    vector = this.getUniqueUserList(vector, string3);
                    this.addUserListToNewGroups("HSC_Admin", string3);
                }
                if (string2.startsWith("HSC_Operator") && (string3 = this.getOldGroupsUserList(string2)) != null) {
                    vector = this.getUniqueUserList(vector, string3);
                    this.addUserListToNewGroups("HSC_Operator", string3);
                }
                if (string2.startsWith("HSC_Adv_Operator") && (string3 = this.getOldGroupsUserList(string2)) != null) {
                    vector = this.getUniqueUserList(vector, string3);
                    this.addUserListToNewGroups("HSC_Adv_Operator", string3);
                }
                if (string2.startsWith("HSC_Serv_Rep") && (string3 = this.getOldGroupsUserList(string2)) != null) {
                    vector = this.getUniqueUserList(vector, string3);
                    this.addUserListToNewGroups("HSC_Serv_Rep", string3);
                }
                if (string2.startsWith("HSC_PEMODE") && (string3 = this.getOldGroupsUserList(string2)) != null) {
                    vector = this.getUniqueUserList(vector, string3);
                    this.addUserListToNewGroups("HSC_PEMODE", string3);
                }
                if (!string2.startsWith("HSC_Viewer") || (string3 = this.getOldGroupsUserList(string2)) == null) continue;
                vector = this.getUniqueUserList(vector, string3);
                this.addUserListToNewGroups("HSC_Viewer", string3);
            }
            this.logIt("About to invoke migrateOldPasswds()...");
            this.migrateOldPasswds(vector);
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of /tmp/restore/work//etc/group. e is " + exception);
        }
        this.logIt("<-- Exit postProcessGroups()");
    }

    private void postProcessShadow() {
        String string = null;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        File file = new File("/tmp/");
        File file2 = null;
        this.logIt("--> Entering postProcessShadow()");
        string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + SHADOW;
        this.executeCommand(string);
        try {
            String string2;
            String string3;
            this.logIt("About to read current /etc/passwd file...");
            arrayList3 = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(PASSWD));
            while ((string3 = bufferedReader.readLine()) != null) {
                arrayList3.add(string3);
            }
            stringArray3 = arrayList3.toArray(new String[arrayList3.size()]);
            this.logIt("About to read /tmp/restore/work//etc/shadow...");
            arrayList2 = new ArrayList<String>();
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader("/tmp/restore/work//etc/shadow"));
            while ((string3 = bufferedReader2.readLine()) != null) {
                arrayList2.add(string3);
            }
            stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
            this.logIt("About to read /etc/shadow...");
            arrayList = new ArrayList<String>();
            file2 = File.createTempFile("tmp", "", file);
            FileWriter fileWriter = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            BufferedReader bufferedReader3 = new BufferedReader(new FileReader(SHADOW));
            while ((string3 = bufferedReader3.readLine()) != null) {
                arrayList.add(string3);
                if (string3.startsWith("hscroot:") || string3.startsWith("root:")) {
                    this.logIt("hscroot detected in prior /etc/shadow data. bypassing writing entry to working file...");
                    continue;
                }
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.newLine();
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n = 0;
            while (n < stringArray3.length) {
                string2 = stringArray3[n];
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                }
                this.logIt("testing if user <" + string4 + "> with GID = " + string6 + ", should be migrated...");
                String string7 = null;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    block19: {
                        string7 = stringArray[n2];
                        if (!string7.startsWith(string4 + ":")) {
                            try {
                                Integer n3 = new Integer(string6);
                                int n4 = n3;
                                if (n4 < 500 || n4 > 508) break block19;
                                this.logIt(string4 + " does not match current entry in /etc/shadow file, but 500 <= GID <= 508. Check continuing...");
                                if (!(string4.equals("ccfw") || string4.equals("invscout") || string4.equals("svcagent") || string4.equals("hscroot") || string4.equals("root"))) {
                                    arrayList4.add(string4);
                                    this.logIt(string4 + " added to /etc/shadow migration list");
                                }
                                break block19;
                            }
                            catch (Exception exception) {
                                this.logIt("exeption caught while processing GID, e is " + exception);
                            }
                            break;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            arrayList4.add("hscroot");
            arrayList4.add("root");
            this.logIt(arrayList4.size() + " prior userIDs to migrate...");
            int n5 = 0;
            while (n5 < arrayList4.size()) {
                string2 = (String)arrayList4.get(n5);
                int n6 = 0;
                while (n6 < stringArray2.length) {
                    if (stringArray2[n6].startsWith(string2 + ":")) {
                        this.logIt("detected <" + string2 + "> prior /etc/shadow data. writing entry...");
                        bufferedWriter.write(stringArray2[n6], 0, stringArray2[n6].length());
                        bufferedWriter.newLine();
                        break;
                    }
                    ++n6;
                }
                ++n5;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + file2.getPath() + " /etc/shadow";
            this.executeCommand(string);
            file2.delete();
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of /tmp/restore/work//etc/shadow. e is " + exception);
        }
        this.logIt("<-- Exit postProcessShadow()");
    }

    public String getOldGroupsUserList(String string) {
        String string2 = null;
        this.logIt("--> Entering getOldGroupsUserList()..., argument is <" + string + ">");
        try {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            this.logIt("userList from archived group file is <" + string2 + ">");
        }
        catch (Exception exception) {
            this.logIt("Exception caught during tokenizing " + string + ". e is " + exception);
            this.logIt("Possible this is ok, returning null");
        }
        this.logIt("<-- Exit getOldGroupsUserList()");
        return string2;
    }

    private Vector getUniqueUserList(Vector vector, String string) {
        String string2 = null;
        this.logIt("--> Entering getUniqueUserList()..., argument is <" + string + ">");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            this.logIt("user found is : " + string2);
            if (vector.contains(string2)) continue;
            vector.addElement(string2);
        }
        this.logIt("<-- Exit getUniqueUserList()");
        return vector;
    }

    private void addUserListToNewGroups(String string, String string2) {
        File file = new File("/tmp/");
        File file2 = null;
        String string3 = null;
        this.logIt("--> Entering addUserListToNewGroups()..., argument are <" + string + ", " + string2 + ">");
        try {
            String string4;
            file2 = File.createTempFile("tmp", "", file);
            FileReader fileReader = new FileReader(GROUP);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.logIt("About to read /etc/group...");
            while ((string4 = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string4 + ">");
                if (string4.startsWith(string)) {
                    int n = string4.lastIndexOf(":");
                    if (n != -1) {
                        string3 = string4.substring(0, n + 1);
                        string3 = string3 + string2;
                        this.logIt("found matching group, entry changed to <" + string3 + ">");
                        bufferedWriter.write(string3, 0, string3.length());
                        bufferedWriter.newLine();
                        continue;
                    }
                    bufferedWriter.write(string4, 0, string4.length());
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            String string5 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + file2.getPath() + " /etc/group";
            this.executeCommand(string5);
            file2.delete();
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of /etc/group. e is " + exception);
        }
        this.logIt("<-- Exit addUserListToNewGroups()");
    }

    private void migrateOldPasswds(Vector vector) {
        Object object;
        File file = new File("/tmp/");
        File file2 = null;
        String string = null;
        boolean bl = false;
        this.logIt("--> Entering migrateOldPasswds()");
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            this.logIt("-- existing user to be processed: " + (String)object);
            ++n;
        }
        try {
            file2 = File.createTempFile("tmp", "", file);
            object = new FileReader(PASSWD);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            FileWriter fileWriter = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.logIt("About to read /etc/passwd...");
            while ((string = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string + ">");
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            object = new FileReader("/tmp/restore/work//etc/passwd");
            bufferedReader = new BufferedReader((Reader)object);
            this.logIt("About to read /tmp/restore/work//etc/passwd...");
            block4: while ((string = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string + ">");
                n = 0;
                while (n < vector.size()) {
                    String string2 = (String)vector.elementAt(n);
                    if (string.startsWith(string2)) {
                        this.logIt("found match, s is <" + string + ">");
                        bl = this.lookForUser(file2, string2);
                        if (!bl) {
                            bufferedWriter.write(string, 0, string.length());
                            bufferedWriter.newLine();
                            continue block4;
                        }
                    }
                    ++n;
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            String string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + file2.getPath() + " /etc/passwd";
            this.executeCommand(string3);
            file2.delete();
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of (/tmp/restore/work/) /etc/passwd. e is " + exception);
        }
        this.logIt("<-- Exit migrateOldPasswds()");
    }

    private boolean lookForUser(File file, String string) {
        boolean bl = false;
        String string2 = null;
        this.logIt("--> Entering lookForUser()..., argument is <" + string + ">");
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.logIt("About to read working passwd file...");
            while ((string2 = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string2 + ">");
                if (!string2.startsWith(string + ":")) continue;
                this.logIt("old user match found in new passwd file");
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            this.logIt("Exception caught while processing working passwd file. e is " + exception);
        }
        this.logIt("<-- Exit lookForUser()");
        return bl;
    }

    public static String getAttrValue(String string, Properties properties) {
        String string2 = properties.getProperty(string, "").trim();
        int n = string2.length();
        return n > 1 && string2.startsWith("\"") && string2.endsWith("\"") ? string2.substring(1, n - 1) : string2;
    }

    private void resetHostname() throws Exception {
        this.logIt("--> Entering resetHostname()");
        String string = "localhost";
        try {
            String string2;
            Object object;
            File file = new File("/etc/HOSTNAME");
            if (file.exists() && file.isFile()) {
                object = new BufferedReader(new FileReader("/etc/HOSTNAME"));
                this.logIt("About to read /etc/HOSTNAME...");
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    this.logIt("line read is <" + string2 + ">");
                    string = string2.trim();
                    if (string.length() >= 1) continue;
                    string = "localhost";
                }
            }
            string2 = "/bin/hostname " + string;
            object = Runtime.getRuntime().exec(string2);
            int n = ((Process)object).waitFor();
            ((Process)object).destroy();
            if (n != 0) {
                throw new Exception("problem setting hostname to <" + string + ">");
            }
        }
        catch (Exception exception) {
            throw new Exception("Exception caught while setting HMC hostname. e is " + exception);
        }
        this.logIt("<-- Exit resetHostname()");
    }

    private void portLocale() throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        this.logIt("--> Entering portLocale()...");
        string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + I18N;
        this.executeCommand(string2);
        try {
            this.logIt("About to read /tmp/restore/work//etc/sysconfig/i18n...");
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/tmp/restore/work//etc/sysconfig/i18n"));
            while ((string = bufferedReader.readLine()) != null) {
                this.logIt("line read is <" + string + ">");
                if (!string.startsWith("LANG")) continue;
                string3 = string;
                bl = true;
                this.logIt("found the prior locale environment setting: <" + string3 + ">");
                break;
            }
            if (bl) {
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("sed") + " -e \"/^export LANG/d\" /etc/SuSEconfig/profile > /etc/SuSEconfig/profile.mod";
                this.executeCommand(string2);
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("mv") + " -f /etc/SuSEconfig/profile.mod /etc/SuSEconfig/profile";
                this.executeCommand(string2);
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("echo") + " export " + string3 + " >> /etc/SuSEconfig/profile";
                this.executeCommand(string2);
            }
        }
        catch (Exception exception) {
            this.logIt("Exception caught during processing of /tmp/restore/work//etc/sysconfig/i18n. e is " + exception);
        }
        this.logIt("<-- Exit portLocale()");
    }

    private void portClock() throws Exception {
        block9: {
            File file = new File("/tmp/");
            BufferedReader bufferedReader = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            this.logIt("--> Entering portClock()...");
            string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xf " + this.archive + " --directory=" + WORKING_DIR + " " + CLOCK;
            this.executeCommand(string2);
            try {
                this.logIt("About to read /tmp/restore/work//etc/sysconfig/clock...");
                bufferedReader = new BufferedReader(new FileReader("/tmp/restore/work//etc/sysconfig/clock"));
                while ((string = bufferedReader.readLine()) != null) {
                    this.logIt("line read is <" + string + ">");
                    if (!string.startsWith("ZONE=")) continue;
                    string3 = string;
                    bl = true;
                    this.logIt("found the prior ZONE environment setting: <" + string3 + ">");
                    break;
                }
                if (!bl) break block9;
                File file2 = File.createTempFile("tmp", "", file);
                FileWriter fileWriter = new FileWriter(file2);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedReader = new BufferedReader(new FileReader(CLOCK));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("HWCLOCK=")) {
                        string = string.substring(0, 8) + "\"-u\"";
                    } else if (string.startsWith("TIMEZONE=")) {
                        String string4;
                        try {
                            string4 = string3.substring(5);
                            this.logIt("Prior timezone value to migrate is <" + string4 + ">");
                        }
                        catch (Exception exception) {
                            this.logIt("Exception <" + exception + "> caught while processing priorTimezone variable <" + string3 + ">");
                            string4 = "";
                        }
                        string = string.substring(0, 9) + string4;
                    }
                    bufferedWriter.write(string, 0, string.length());
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + file2.getPath() + " /etc/sysconfig/clock";
                this.executeCommand(string2);
                file2.delete();
            }
            catch (Exception exception) {
                this.logIt("Exception caught during processing of /tmp/restore/work//etc/sysconfig/clock. e is " + exception);
            }
        }
        this.logIt("<-- Exit portClock()");
    }

    private void changeFilePermissions() throws Exception {
        this.logIt("--> Entering changeFilePermissions()");
        String string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("chown") + " root.nogroup " + HTTPD_USERS;
        try {
            this.executeCommand(string);
        }
        catch (Exception exception) {
            throw new Exception("Exception caught while issuing OS command. e is " + exception);
        }
        this.logIt("<-- Exit changeFilePermissions()");
    }

    private int executeCommand(String string) {
        this.logIt("*- About to issue the command: <" + string + ">");
        EExecResult eExecResult = EExec.Exec((String)string);
        if (eExecResult.rc != 0) {
            this.logIt("command failed, rc = " + eExecResult.rc + "...");
            this.logIt("...stderr is <" + eExecResult.stderr + ">");
        }
        return eExecResult.rc;
    }

    public static void main(String[] stringArray) {
        try {
            new RestoreHSCSystemUpgradeData("/mnt/upgrade/SaveHSCSystemUpgradeData.tar");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

